/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.models.entities;

import com.alexander.mutantmore.entities.MutantWitherSkeleton;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.molang.MolangParser;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedTickingGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class MutantWitherSkeletonModel
extends AnimatedTickingGeoModel<MutantWitherSkeleton> {
    public ResourceLocation getAnimationResource(MutantWitherSkeleton entity) {
        return new ResourceLocation("mutantmore", "animations/mutant_wither_skeleton.animation.json");
    }

    public ResourceLocation getModelResource(MutantWitherSkeleton entity) {
        return new ResourceLocation("mutantmore", "geo/mutant_wither_skeleton.geo.json");
    }

    public ResourceLocation getTextureResource(MutantWitherSkeleton entity) {
        return new ResourceLocation("mutantmore", "textures/entities/mutant_wither_skeleton.png");
    }

    public void setLivingAnimations(MutantWitherSkeleton entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone neck = this.getAnimationProcessor().getBone("neck");
        IBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (Minecraft.m_91087_().m_91104_()) {
            if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
                head.setRotationX(head.getRotationX());
                head.setRotationY(head.getRotationY());
                neck.setRotationX(neck.getRotationX());
                neck.setRotationY(neck.getRotationY());
            }
        } else if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 2.0f);
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 2.0f);
            neck.setRotationX(neck.getRotationX() + extraData.headPitch * ((float)Math.PI / 180) / 2.0f);
            neck.setRotationY(neck.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180) / 2.0f);
        }
    }

    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        super.setMolangQueries(animatable, currentTick);
        MolangParser parser = GeckoLibCache.getInstance().parser;
        LivingEntity livingEntity = (LivingEntity)animatable;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        parser.setValue("query.ground_speed", (double)(groundSpeed * 10.0f));
    }
}

